#version 430

layout (location = 0) in vec4 fragViewPos;
layout (location = 1) in smooth vec3 fragNormal;
layout (location = 2) in vec4 fragPosLightSpace;

layout (location = 0) out vec4 bAlbedoSpec;
layout (location = 1) out vec4 bViewPosition;
layout (location = 2) out vec3 bNormal;
layout (location = 3) out vec4 bPhysical;
layout (location = 4) out vec2 bInstanceID;
layout (location = 5) out vec4 bLightPos;

layout (binding = 1) uniform sampler2D gViewPos;
layout (binding = 2) uniform samplerCube skybox;

uniform float nearPlane;
uniform float farPlane;

uniform int modelID;

uniform vec3 waterColor;

uniform int screenWidth;
uniform int screenHeight;


float toLinearDepth(float zDepth){
	float near = nearPlane;
	float far = farPlane;
	return 2.0 * near * far / (far + near - (2.0 * zDepth - 1.0) * (far - near));
}

float linearize_depth(float d,float zNear,float zFar)
{
  float z_n = 2.0 * d - 1.0;
  return 2.0 * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));
}

float calculateWaterDepth(vec2 texCoords){
	return texture(gViewPos, texCoords).w - linearize_depth(gl_FragCoord.z, 1.0, 6000);
}

vec2 clipSpaceToTexCoords(vec4 clipSpace){
	vec2 ndc = (clipSpace.xy / clipSpace.w);
	vec2 texCoords = ndc / 2.0 + 0.5;
	return clamp(texCoords, 0.002, 0.998);
}

float calculateAlpha(float waterDepth){ //jenky but works fine
	
	float alpha = 0.0;

	alpha = abs(waterDepth) / (2.0f);
	alpha = clamp(alpha, 0.0, 1.0);

	return alpha;
		
}


void main(){


		vec2 coords;
		coords.x = (gl_FragCoord.x / screenWidth); // this was the demon tweak
		coords.y = (gl_FragCoord.y / screenHeight);

		float waterDepth = calculateWaterDepth(coords);
 
		bAlbedoSpec.xyz = waterColor;

		bPhysical.w = calculateAlpha(waterDepth);
		bPhysical.r = 0.3; //roughness

		bViewPosition.xyz = fragViewPos.xyz;

		bViewPosition.w = linearize_depth(gl_FragCoord.z, 1.0, 6000);

		bNormal = fragNormal;
	
		bLightPos.xyz = (fragPosLightSpace.xyz / fragPosLightSpace.w) * 0.5 + 0.5;

		bInstanceID = vec2(modelID, 0);


}